/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.basic.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.utils.ListHelper;
import net.sixik.sdmshoprework.network.server.SendChangesShopC2S;
import net.sixik.sdmshoprework.network.server.create.SendCreateShopTabC2S;
import net.sixik.sdmshoprework.network.server.edit.SendEditShopTabC2S;

public abstract class AbstractShopTabButton
extends SimpleTextButton {
    public ShopTab shopTab;
    public boolean isEdit = false;

    public AbstractShopTabButton(Panel panel, ShopTab shopTab) {
        super(panel, (Component)(shopTab != null ? shopTab.title : Component.m_237119_()), (Icon)(shopTab != null ? shopTab.getIcon() : Color4I.EMPTY));
        this.shopTab = shopTab;
    }

    public AbstractShopTabButton setEdit() {
        this.isEdit = true;
        this.title = Component.m_237113_((String)"Create");
        this.icon = Icons.ADD;
        return this;
    }

    public void addMouseOverText(TooltipList list) {
        list.add(this.getTitle());
        if (this.shopTab != null && !this.shopTab.descriptionList.isEmpty()) {
            list.add((Component)Component.m_237119_());
            for (String s : this.shopTab.descriptionList) {
                list.add((Component)Component.m_237115_((String)s));
            }
        }
    }

    public void onClicked(MouseButton mouseButton) {
        try {
            if (mouseButton.isLeft()) {
                if (this.isEdit) {
                    new SendCreateShopTabC2S(new ShopTab(ShopBase.CLIENT).serializeNBT()).sendToServer();
                    this.getShopScreen().refreshWidgets();
                } else {
                    this.getShopScreen().setSelectedTab(this.shopTab);
                    this.getShopScreen().addEntriesButtons();
                }
            } else if (mouseButton.isRight() && SDMShopR.isEditMode() && !this.isEdit) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.edit"), Icons.SETTINGS, () -> {
                    ConfigGroup group = new ConfigGroup("sdmr").setNameKey("sidebar_button.sdmr.shop");
                    group.savedCallback = b -> {
                        if (b) {
                            new SendEditShopTabC2S(this.shopTab.shopTabUUID, this.shopTab.serializeNBT()).sendToServer();
                            this.getShopScreen().refreshWidgets();
                        }
                        this.openGui();
                    };
                    ConfigGroup g = group.getGroup("shop").getGroup("tab");
                    this.shopTab.getConfig(g);
                    new EditConfigScreen(group).openGui();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.delete"), Icons.REMOVE, () -> {
                    if (this.getShopScreen().selectedTab != null && this.getShopScreen().selectedTab.shopTabUUID.equals(this.shopTab.shopTabUUID)) {
                        this.getShopScreen().selectedTab = null;
                    }
                    ShopBase.CLIENT.getShopTabs().remove(this.shopTab);
                    new SendChangesShopC2S(ShopBase.CLIENT.serializeNBT()).sendToServer();
                    this.getShopScreen().tabsPanel.refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.up"), Icons.UP, () -> {
                    this.moveNew(true);
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.down"), Icons.DOWN, () -> {
                    this.moveNew(false);
                    this.getShopScreen().refreshWidgets();
                }));
                this.getShopScreen().openContextMenu(contextMenu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveNew(boolean isUp) {
        try {
            int index = this.shopTab.getIndex();
            if (isUp) {
                ListHelper.moveUp(ShopBase.CLIENT.getShopTabs(), index);
            } else {
                ListHelper.moveDown(ShopBase.CLIENT.getShopTabs(), index);
            }
            new SendChangesShopC2S(ShopBase.CLIENT.serializeNBT()).sendToServer();
            this.getShopScreen().refreshWidgets();
        }
        catch (Exception e) {
            SDMShopRework.LOGGER.error(e.toString());
        }
    }

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(graphics, theme, x, y, w, h);
    }

    public void drawSelected(PoseStack graphics, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((PoseStack)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)SDMShopClient.getTheme().getColorSelectTab(), (boolean)false);
    }

    public AbstractShopScreen getShopScreen() {
        return (AbstractShopScreen)this.getGui();
    }
}

